﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Chatter;

namespace ChatterBot
{
    public partial class ChatWindow : Form
    {
        Chatter.Chatter myChatter = new Chatter.Chatter(Application.ExecutablePath.Substring(0, Application.ExecutablePath.LastIndexOf("\\")));

        public ChatWindow()
        {
            InitializeComponent();
        }

        private void buttonSay_Click(object sender, EventArgs e)
        {
            Say();
        }

        private void ChatWindow_Load(object sender, EventArgs e)
        {
            myChatter.ChatterSay += new Chatter.Chatter.ChatterSaysHandler(myChatter_ChatterSay);
        }

        void myChatter_ChatterSay(string text)
        {
            richTextBoxHistory.Text += "Chatterbot: " + text + Environment.NewLine;
        }

        private void textBoxUtterance_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar==(char)13) Say();
        }

        private void Say()
        {
            if (textBoxUtterance.Text == String.Empty) return;

            richTextBoxHistory.Text += "You: " + textBoxUtterance.Text + Environment.NewLine;
            try
            {
                myChatter.SayToChatter(textBoxUtterance.Text);
                textBoxUtterance.Text = "";
            }
            catch (Exception ex)
            {
                richTextBoxHistory.Text += "Error! " + ex.Message + Environment.NewLine;
            }
        }

        private void richTextBoxHistory_TextChanged(object sender, EventArgs e)
        {
            richTextBoxHistory.SelectionStart = richTextBoxHistory.Text.Length;
            richTextBoxHistory.ScrollToCaret();
        }
    }
}
